/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.tools;

import com.mckoi.util.CommandLine;
import com.mckoi.util.ResultOutputUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JDBCScriptTool {
    private Reader in;
    private PrintWriter out;

    public JDBCScriptTool(Reader input, PrintWriter output) {
        this.in = input;
        this.out = output;
    }

    private String nextQuery() throws IOException {
        StringBuffer query = new StringBuffer();
        int c = this.in.read();
        boolean command = false;
        while (c != -1) {
            if (command || c != 32 && c != 10 && c != 13 && c != 9) {
                command = true;
            }
            query.append((char)c);
            if (c == 59) {
                return new String(query);
            }
            c = this.in.read();
        }
        if (!command) {
            return null;
        }
        return new String(query);
    }

    public Connection[] evaluate(Connection connection, String url, String username, String password) throws IOException {
        Statement statement;
        try {
            statement = connection.createStatement();
        }
        catch (SQLException e) {
            this.out.println("SQL Error creating statement: " + e.getMessage());
            return new Connection[]{connection};
        }
        Hashtable<String, Connection> connections = new Hashtable<String, Connection>();
        connections.put("default", connection);
        String query = this.nextQuery();
        while (query != null) {
            try {
                String command = query.substring(0, query.length() - 1).trim().toLowerCase();
                if (command.startsWith("switch to connection ")) {
                    String connection_name = command.substring(21);
                    Connection c = (Connection)connections.get(connection_name);
                    if (c == null) {
                        c = DriverManager.getConnection(url, username, password);
                        connections.put(connection_name, c);
                        this.out.println("Established Connection: " + connection_name);
                    }
                    statement = c.createStatement();
                    this.out.println("Switched to Connection: " + connection_name);
                    this.out.flush();
                } else if (command.startsWith("//")) {
                    this.out.println();
                    this.out.println(command);
                    this.out.flush();
                } else {
                    this.out.println();
                    this.out.print("> ");
                    this.out.println(query.trim());
                    ResultSet result_set = statement.executeQuery(query);
                    ResultOutputUtil.formatAsText(result_set, this.out);
                    this.out.flush();
                }
            }
            catch (SQLException e) {
                this.out.println("SQL Error running query (\n" + query + "\n)\nError: " + e.getMessage());
                this.out.println("Error code: " + e.getErrorCode());
            }
            this.out.flush();
            query = this.nextQuery();
        }
        Enumeration e = connections.elements();
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        Connection[] arr = new Connection[v.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (Connection)v.elementAt(i);
        }
        return arr;
    }

    private static void printSyntax() {
        System.out.println("JDBCScriptTool [-jdbc JDBC_Driver_Class] [-url JDBC_URL] \n               -u username -p password \n               [-in Input_SQL_File] [-out Output_Result_File] \n\n  If -in or -out are not specified then the tool uses System.in \n  and System.out respectively.\n");
    }

    public static void main(String[] args) {
        CommandLine cl = new CommandLine(args);
        String driver = cl.switchArgument("-jdbc", "com.mckoi.JDBCDriver");
        String url = cl.switchArgument("-url", ":jdbc:mckoi:");
        String username = cl.switchArgument("-u");
        String password = cl.switchArgument("-p");
        String input_file = cl.switchArgument("-in");
        String output_file = cl.switchArgument("-out");
        if (username == null) {
            System.out.println("Please provide a username");
            System.out.println();
            JDBCScriptTool.printSyntax();
            System.exit(1);
        } else if (password == null) {
            System.out.println("Please provide a password");
            System.out.println();
            JDBCScriptTool.printSyntax();
            System.exit(1);
        }
        Reader reader = null;
        PrintWriter writer = null;
        try {
            reader = input_file == null ? new InputStreamReader(System.in) : new BufferedReader(new FileReader(input_file));
            writer = output_file == null ? new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out))) : new PrintWriter(new BufferedWriter(new FileWriter(output_file)));
        }
        catch (IOException e) {
            System.err.println("IO Error: " + e.getMessage());
            JDBCScriptTool.printSyntax();
            System.exit(1);
        }
        JDBCScriptTool tool = new JDBCScriptTool(reader, writer);
        Connection connection = null;
        try {
            writer.println("Using JDBC Driver: " + driver);
            Class.forName(driver).newInstance();
            connection = DriverManager.getConnection(url, username, password);
            writer.println("Connection established to: " + url);
            writer.flush();
        }
        catch (ClassNotFoundException e) {
            writer.println("JDBC Driver not found.");
            JDBCScriptTool.printSyntax();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            JDBCScriptTool.printSyntax();
            System.exit(1);
        }
        try {
            if (input_file != null) {
                System.out.println("Script input from: " + input_file);
            }
            Connection[] conl = tool.evaluate(connection, url, username, password);
            reader.close();
            writer.println();
            writer.println(" --- FINISHED");
            writer.close();
            for (int i = 0; i < conl.length; ++i) {
                conl[i].close();
            }
            if (output_file != null) {
                System.out.println("Script output to: " + output_file);
            }
        }
        catch (IOException e) {
            System.err.println("IO Error: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (SQLException e) {
            System.err.println("SQL Error: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

